
Class Orb

	Public
	
	Method New (rocket:Rocket, distance:Float, mass:Float = 1.0)

		Local mat:PbrMaterial = New PbrMaterial (Color.HotPink)
		
		model			= Model.CreateSphere (0.75, 32, 32, mat)
		
		' Position model BEFORE adding physics components; set here
		' to rocket position less 'distance' below rocket...
		
		#Rem
		
		
			^		ROCKET			constraint.Pivot				This is the BALL socket (at rocket position)
			|
			|
			|		distance
			|
			|
			O		ORB				constraint.ConnectedPivot		This is a FIXED point (at orb position)
			
			
		#End
		
		model.Position				= rocket.RocketModel.Position + New Vec3f (0.0, -distance, 0.0)
		
			model.Alpha				= 0.75
			model.CastsShadow		= True
		
		glow = New Light (model)
		
			glow.Type				= LightType.Point ' Very slow to init!
			glow.CastsShadow		= False'True ' TODO - may be fixed in future
			glow.Color				= Color.HotPink * 8.0
			glow.Range				= 10.0
		
		body						= model.AddComponent <RigidBody> ()
		collider					= model.AddComponent <SphereCollider> ()

			body.Mass				= mass
			body.Restitution		= 0.1
			body.AngularDamping		= 0.45
			
			body.CollisionMask		= COLL_ORB
			body.CollisionGroup		= ORB_COLLIDES_WITH

		constraint					= model.AddComponent <BallSocketJoint> ()
		
		' constraint.Pivot at ROCKET position (upwards by 'distance')...
		
		' BALL SOCKET
		
		constraint.Pivot			= New Vec3f (0.0, distance, 0.0)

		' constraint.ConnectedPivot at ORB position (0, 0, 0 relative to orb)...
		
		' FIXED POINT
		
		' But constraint.ConnectedBody is the ROCKET body here... all a matter of
		' perspective, since you could have the ball socket (Pivot) at orb position
		' instead...
		
		constraint.ConnectedBody	= rocket.RocketBody
		
	End

	Method Destroy:Void ()
		model?.Destroy ()
		If body Then body = Null
	End

	Method DetachFromRocket ()
		constraint.Destroy ()
	End
	
	Private
	
	Field model:Model
	Field body:RigidBody
	Field collider:SphereCollider

	Field glow:Light
	
	Field constraint:BallSocketJoint
	
End
